﻿using log4net;
using Microsoft.WindowsAzure.Storage;
using Microsoft.WindowsAzure.Storage.Queue;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.Common;
using VA.PPMS.IWS.Functions.Configuration.Interface;
using VA.PPMS.IWS.QueueService.Interface;

namespace VA.PPMS.IWS.QueueService
{
    public class QueueService : IQueueService
    {
        private readonly ILog _logger;
        private readonly IIwsConfiguration _configuration;

        public QueueService(ILog logger, IIwsConfiguration configuration)
        {
            _logger = logger;
            _configuration = configuration;
        }

        public async Task PutDasQueueAsync(DasMessage message)
        {
            _logger.Info($"@@@@ INFO - Start PutDasQueueAsync @@@@");

            var queueName = await _configuration.GetProviderPayloadQueueAsync();
            var queue = await GetQueue(queueName);

            var cloudQueueMessage = new CloudQueueMessage(message.ToString());
            await queue.AddMessageAsync(cloudQueueMessage);

            _logger.Info($"@@@@ INFO - End PutDasQueueAsync @@@@");
        }

        public async Task PutResponseQueueQueueAsync(DasMessage message)
        {
            _logger.Info($"@@@@ INFO - Start PutResponseQueueQueueAsync @@@@");

            var queueName = await _configuration.GetResponseQueueNameAsync();
            var queue = await GetQueue(queueName);

            var cloudQueueMessage = new CloudQueueMessage(message.ToString());
            await queue.AddMessageAsync(cloudQueueMessage);

            _logger.Info($"@@@@ INFO - End PutResponseQueueQueueAsync @@@@");
        }

        public async Task<bool> PutProviderQueueAsync(string message)
        {
            _logger.Info("@@@@ INFO - Start PutProviderQueueAsync  @@@@");

            var queueName = await _configuration.GetCcnDocRefQueueNameAsync();
            var queue = await GetQueue(queueName);

            var cloudQueueMessage = new CloudQueueMessage(message);
            await queue.AddMessageAsync(cloudQueueMessage);

            _logger.Info("@@@@ INFO - End PutProviderQueueAsync @@@@");

            return true;
        }

        private async Task<CloudQueue> GetQueue(string queueName)
        {
            var storageAccountString = await _configuration.GetConnectionAsync();

            var storageAccount = CloudStorageAccount.Parse(storageAccountString);
            var queueClient = storageAccount.CreateCloudQueueClient();
            var queue = queueClient.GetQueueReference(queueName);
            queue.CreateIfNotExists();

            return queue;
        }
    }
}